/*
 * $Id: acs4java.c,v 1.4 2003/05/21 10:30:55 cvs Exp $
 */



#include <jni.h>
#include "StorageLibraryHandler.h"
#include <acssys.h>
#include <acsapi.h>
#include <string.h>

#define acsMount               Java_StorageLibraryHandler_acsMount
#define acsDismount            Java_StorageLibraryHandler_acsDismount
#define acsQueryServer         Java_StorageLibraryHandler_acsQueryServer
#define acsQueryDrive          Java_StorageLibraryHandler_acsQueryDrive
#define acsQueryVolume         Java_StorageLibraryHandler_acsQueryVolume
#define acsQueryVolumeResponse Java_StorageLibraryHandler_acsQueryVolumeResponse
#define acsQueryDriveResponse  Java_StorageLibraryHandler_acsQueryDriveResponse
#define acsMountResponse       Java_StorageLibraryHandler_acsMountResponse
#define acsDismountResponse    Java_StorageLibraryHandler_acsDismountResponse
#define acsResponse            Java_StorageLibraryHandler_acsResponse
#define acsCancel              Java_StorageLibraryHandler_acsCancel
#define acsCancelResponse      Java_StorageLibraryHandler_acsCancelResponse
#define acsStatus              Java_StorageLibraryHandler_acsStatus
#define acsState              Java_StorageLibraryHandler_acsState


static void DRIVEID2OBJECT( DRIVEID *drive_id, jobject drive_obj, JNIEnv *j_env)
{

	jclass drive_class = (*j_env)->GetObjectClass(j_env, drive_obj);

	/*	get method pointers */
	jmethodID drive_setDrive = (*j_env)->GetMethodID(j_env, drive_class, "setDrive", "(I)V" );
	jmethodID drive_setAcs = (*j_env)->GetMethodID(j_env, drive_class, "setAcs", "(I)V" );
	jmethodID drive_setLsm = (*j_env)->GetMethodID(j_env, drive_class, "setLsm", "(I)V" );
	jmethodID drive_setPanel = (*j_env)->GetMethodID(j_env, drive_class, "setPanel", "(I)V" );


	(*j_env)->CallVoidMethod(j_env, drive_obj, drive_setDrive, drive_id->drive);
	(*j_env)->CallVoidMethod(j_env, drive_obj, drive_setAcs,   drive_id->panel_id.lsm_id.acs);
	(*j_env)->CallVoidMethod(j_env, drive_obj, drive_setLsm,   drive_id->panel_id.lsm_id.lsm);		
	(*j_env)->CallVoidMethod(j_env, drive_obj, drive_setPanel, drive_id->panel_id.panel);


}


static void OBJECT2DRIVEID( jobject drive_obj, DRIVEID *drive_id, JNIEnv *j_env )
{


	static jmethodID getDrive;
	static jmethodID getAcs;
	static jmethodID getLsm;
	static jmethodID getPanel;
	static int init;
	
	
	if( !init ) {
		jclass drive_class = (*j_env)->GetObjectClass(j_env, drive_obj);

		getDrive = (*j_env)->GetMethodID(j_env, drive_class, "getDrive", "()I" );
		getAcs =   (*j_env)->GetMethodID(j_env, drive_class, "getAcs",   "()I" );
		getLsm =   (*j_env)->GetMethodID(j_env, drive_class, "getLsm",   "()I" );
		getPanel = (*j_env)->GetMethodID(j_env, drive_class, "getPanel", "()I" );
		
		init ++;

	}
	/* fill the original ACSLS DRIVEID structure */

	drive_id->drive = (*j_env)->CallIntMethod(j_env, drive_obj, getDrive);
	drive_id->panel_id.lsm_id.acs = (*j_env)->CallIntMethod(j_env, drive_obj, getAcs);
	drive_id->panel_id.lsm_id.lsm = (*j_env)->CallIntMethod(j_env, drive_obj, getLsm);
	drive_id->panel_id.panel = (*j_env)->CallIntMethod(j_env, drive_obj, getPanel);		

}



static void VOLID2OBJECT( VOLID *vol_id, jobject volumeId_object, JNIEnv *j_env)
{

	static jmethodID  setVolumeId;
	
	if( setVolumeId == NULL ) {
		jclass volumeId_class = (*j_env)->GetObjectClass(j_env, volumeId_object);			
		setVolumeId = (*j_env)->GetMethodID(j_env, volumeId_class, "setVolumeId", "(Ljava/lang/String;)V" );
	}

	vol_id->external_label[EXTERNAL_LABEL_SIZE] = '\0';
	jstring j_volume = (*j_env)->NewStringUTF(j_env, vol_id->external_label);
	if( j_volume == NULL ) {
		/* out of memory exception 
		printf("Out of memory exception\n"); fflush(stdout); */
		return;
	}
	(*j_env)->CallVoidMethod(j_env, volumeId_object , setVolumeId , j_volume);

}


static void OBJECT2VOLID( jobject volumeId_object, VOLID *vol_id, JNIEnv *j_env)
{

	static jmethodID getVolumeId;
	jclass volume_class;
	jstring j_volume;

	if( getVolumeId == NULL ) {
		volume_class = (*j_env)->GetObjectClass(j_env, volumeId_object);
		getVolumeId = (*j_env)->GetMethodID(j_env, volume_class, "getVolumeId", "()Ljava/lang/String;" );
	}

	j_volume = (jstring)(*j_env)->CallObjectMethod(j_env, volumeId_object, getVolumeId );
	const char *volume = (*j_env)->GetStringUTFChars(j_env, j_volume , NULL);
	strcpy( vol_id->external_label, volume );
	(*j_env)->ReleaseStringUTFChars(j_env, j_volume, volume);


}


static void CELLID2OBJECT( CELLID *cell_id, jobject cell_obj, JNIEnv *j_env)
{

	jclass cell_class = (*j_env)->GetObjectClass(j_env, cell_obj);

	/*	get method pointers */
	jmethodID setRow = (*j_env)->GetMethodID(j_env, cell_class, "setRow", "(I)V" );
	jmethodID setCol = (*j_env)->GetMethodID(j_env, cell_class, "setCol", "(I)V" );	
	jmethodID setAcs = (*j_env)->GetMethodID(j_env, cell_class, "setAcs", "(I)V" );
	jmethodID setLsm = (*j_env)->GetMethodID(j_env, cell_class, "setLsm", "(I)V" );
	jmethodID setPanel = (*j_env)->GetMethodID(j_env, cell_class, "setPanel", "(I)V" );


	(*j_env)->CallVoidMethod(j_env, cell_obj, setRow, cell_id->row);
	(*j_env)->CallVoidMethod(j_env, cell_obj, setCol, cell_id->col);
	(*j_env)->CallVoidMethod(j_env, cell_obj, setAcs,   cell_id->panel_id.lsm_id.acs);
	(*j_env)->CallVoidMethod(j_env, cell_obj, setLsm,   cell_id->panel_id.lsm_id.lsm);		
	(*j_env)->CallVoidMethod(j_env, cell_obj, setPanel, cell_id->panel_id.panel);


}

JNIEXPORT int JNICALL
acsMount(JNIEnv *j_env, jobject j_obj, jint j_seqNum, jint j_lockId, jobject j_volId, jobject j_drvId, jboolean j_readonly, jboolean j_bypass)
{

	int rc;
	
	SEQ_NO seqNum = j_seqNum;
	LOCKID lockId = j_lockId;
	VOLID volId;
	DRIVEID driveId;
	
	BOOLEAN readonly = j_readonly;
	BOOLEAN bypass = j_bypass;
	

	OBJECT2DRIVEID( j_drvId, &driveId, j_env );
	OBJECT2VOLID( j_volId, &volId, j_env );
	
	rc = acs_mount(seqNum,lockId, volId, driveId, readonly, bypass);

	return rc;

}



JNIEXPORT int JNICALL
acsDismount(JNIEnv *j_env, jobject j_obj, jint j_seqNum, jint j_lockId, jobject j_volId, jobject j_drvId, jboolean j_force)
{

	int rc;
	
	SEQ_NO seqNum = j_seqNum;
	LOCKID lockId = j_lockId;
	VOLID volId;
	DRIVEID driveId;
	
	BOOLEAN force = j_force;


	OBJECT2DRIVEID( j_drvId, &driveId, j_env );
	OBJECT2VOLID( j_volId, &volId, j_env );

	
	rc = acs_dismount(seqNum,lockId, volId, driveId, force);

	return rc;

}


JNIEXPORT int JNICALL
acsQueryVolume(JNIEnv *j_env, jobject j_obj, jint j_seqNum, jobjectArray j_volumeArray, jint j_count)
{
	int rc;
	SEQ_NO seqNum = j_seqNum;
	VOLID volumeId[MAX_ID];
	unsigned short count = (unsigned short)j_count;
	int i;

	jobject element;

	for( i = 0; i < count; i++ ){
		element = (*j_env)->GetObjectArrayElement(j_env, j_volumeArray,i);
		OBJECT2VOLID( element, &volumeId[i], j_env );
	}

	rc = acs_query_volume(seqNum, volumeId, count);

	return rc;
}


JNIEXPORT int JNICALL
acsQueryDrive(JNIEnv *j_env, jobject j_obj, jint j_seqNum, jobjectArray j_driveArray, jint j_count)
{
	int rc;
	SEQ_NO seqNum = j_seqNum;
	DRIVEID driveId[MAX_ID];
	unsigned short count = (unsigned short)j_count;
	int i;
	jobject element;
	
	for( i = 0; i < count; i++ ){
		element = (*j_env)->GetObjectArrayElement(j_env, j_driveArray,i);
		OBJECT2DRIVEID( element, &driveId[i], j_env );
	}
	
	
	rc = acs_query_drive(seqNum, driveId, count);

	return rc;
}

JNIEXPORT int JNICALL
acsResponse(JNIEnv *j_env, jobject j_obj, jint j_timeout, jobject j_res)
{
	int rc;
	int timeout = j_timeout;
	
	SEQ_NO seqNum;
	REQ_ID reqId;
	ACS_RESPONSE_TYPE responseType;
	jboolean isCopy;

	static jmethodID getData;
	static jmethodID setSeqNum;
	static jmethodID setReqId;
	static jmethodID setResponseType;
	static int init;
	
	if( !init ) {
	
		jclass 	csl = (*j_env)->GetObjectClass(j_env, j_res);
		getData  = (*j_env)->GetMethodID(j_env, csl, "getData", "()[B" );
		setSeqNum     = (*j_env)->GetMethodID(j_env, csl, "setSeqNum", "(I)V" );
		setReqId      = (*j_env)->GetMethodID(j_env, csl, "setReqId", "(I)V" );
		setResponseType   = (*j_env)->GetMethodID(j_env, csl, "setResponseType", "(I)V" );
		init ++;
	}
	
	jbyteArray j_data = (jbyteArray)(*j_env)->CallObjectMethod(j_env, j_res, getData );
	jbyte *rbuf = (*j_env)->GetByteArrayElements(j_env, j_data, &isCopy);


 	rc = acs_response(timeout, &seqNum,  &reqId, &responseType, (void *)rbuf);
	
	
	if( isCopy == JNI_TRUE ) {
		(*j_env)->ReleaseByteArrayElements(j_env, j_data, rbuf, 0);
	}
	
	
	if( rc == STATUS_SUCCESS ) {
		(*j_env)->CallVoidMethod(j_env, j_res, setSeqNum, seqNum );
		(*j_env)->CallVoidMethod(j_env, j_res, setReqId,  reqId);
		(*j_env)->CallVoidMethod(j_env, j_res, setResponseType,  responseType);
	}
		
	return rc;
}




JNIEXPORT void JNICALL
acsMountResponse(JNIEnv *j_env, jobject j_obj, jbyteArray j_data, jobject j_res)
{

	ACS_MOUNT_RESPONSE *acsResponse;
	jclass csl;
	
	
	jbyte *rbuf = (*j_env)->GetByteArrayElements(j_env, j_data, NULL);
	
	acsResponse = (ACS_MOUNT_RESPONSE *)rbuf;
		
	csl = (*j_env)->GetObjectClass(j_env, j_res);
		
	/* get method pointers */
	
	jmethodID setStatus      = (*j_env)->GetMethodID(j_env, csl, "setStatus", "(I)V" );
	(*j_env)->CallVoidMethod(j_env, j_res, setStatus, acsResponse->mount_status );

	
	if( acsResponse->mount_status == STATUS_SUCCESS ) {
		
		/* get method pointers */
		jmethodID qds_getDriveId = (*j_env)->GetMethodID(j_env, csl, "getDriveId", "()LDriveId;" );
		jmethodID qds_getVolumeId = (*j_env)->GetMethodID(j_env, csl, "getVolumeId", "()LVolumeId;" );


		jobject qds_drive = (*j_env)->CallObjectMethod(j_env, j_res, qds_getDriveId);
		DRIVEID2OBJECT( &(acsResponse->drive_id), qds_drive, j_env );

		jobject qds_volume = (*j_env)->CallObjectMethod(j_env, j_res, qds_getVolumeId);
		VOLID2OBJECT( &(acsResponse->vol_id), qds_volume, j_env);

	}
			
	return ;
}


JNIEXPORT void JNICALL
acsDismountResponse(JNIEnv *j_env, jobject j_obj, jbyteArray j_data, jobject j_res)
{

	ACS_DISMOUNT_RESPONSE *acsResponse;
	jclass csl;
	
	
	jbyte *rbuf = (*j_env)->GetByteArrayElements(j_env, j_data, NULL);
	
	acsResponse = (ACS_DISMOUNT_RESPONSE *)rbuf;
		
	csl = (*j_env)->GetObjectClass(j_env, j_res);
		
	/* get method pointers */
	
	jmethodID setStatus      = (*j_env)->GetMethodID(j_env, csl, "setStatus", "(I)V" );
	(*j_env)->CallVoidMethod(j_env, j_res, setStatus, acsResponse->dismount_status );

	
	if( acsResponse->dismount_status == STATUS_SUCCESS ) {
		
		/* get method pointers */
		jmethodID qds_getDriveId = (*j_env)->GetMethodID(j_env, csl, "getDriveId", "()LDriveId;" );
		jmethodID qds_getVolumeId = (*j_env)->GetMethodID(j_env, csl, "getVolumeId", "()LVolumeId;" );


		jobject qds_drive = (*j_env)->CallObjectMethod(j_env, j_res, qds_getDriveId);
		DRIVEID2OBJECT( &(acsResponse->drive_id), qds_drive, j_env );

		jobject qds_volume = (*j_env)->CallObjectMethod(j_env, j_res, qds_getVolumeId);
		VOLID2OBJECT( &(acsResponse->vol_id), qds_volume, j_env);

	}
			
	return ;
}





JNIEXPORT void JNICALL
acsQueryDriveResponse(JNIEnv *j_env, jobject j_obj, jbyteArray j_data, jobject j_res)
{
	int i;
	ACS_QUERY_DRV_RESPONSE *acsResponse;
	jclass csl;
	
	
	jbyte *rbuf = (*j_env)->GetByteArrayElements(j_env, j_data, NULL);
	
	acsResponse = (ACS_QUERY_DRV_RESPONSE *)rbuf;
		
	csl = (*j_env)->GetObjectClass(j_env, j_res);
		
	/* get method pointers */
	
	jmethodID setStatus      = (*j_env)->GetMethodID(j_env, csl, "setStatus", "(I)V" );
	(*j_env)->CallVoidMethod(j_env, j_res, setStatus, acsResponse->query_drv_status );


	if( acsResponse->query_drv_status == STATUS_SUCCESS ) {


		jmethodID setCount       = (*j_env)->GetMethodID(j_env, csl, "setCount", "(I)V" );
		jmethodID getDriveStatus = (*j_env)->GetMethodID(j_env, csl, "getDriveStatus", "(I)LQU_DRV_STATUS;" );

		(*j_env)->CallVoidMethod(j_env, j_res, setCount, acsResponse->count );

		for ( i = 0; i < acsResponse->count; i++) {

			/* get QU_DRV_STATUS */
			jobject qds = (*j_env)->CallObjectMethod(j_env, j_res, getDriveStatus, i);
			jclass e_csl = (*j_env)->GetObjectClass(j_env, qds);

			/* get method pointers */
			jmethodID qds_getDriveId = (*j_env)->GetMethodID(j_env, e_csl, "getDriveId", "()LDriveId;" );
			jmethodID qds_getVolumeId = (*j_env)->GetMethodID(j_env, e_csl, "getVolumeId", "()LVolumeId;" );
			jmethodID qds_setDriveType = (*j_env)->GetMethodID(j_env, e_csl, "setDriveType", "(C)V" );
			jmethodID qds_setState = (*j_env)->GetMethodID(j_env, e_csl, "setState", "(I)V" );
			jmethodID qds_setStatus = (*j_env)->GetMethodID(j_env, e_csl, "setStatus", "(I)V" );


			/* fill QU_DRV_STATUS */
			(*j_env)->CallVoidMethod(j_env, qds, qds_setStatus, acsResponse->drv_status[i].status );
			(*j_env)->CallVoidMethod(j_env, qds, qds_setState, acsResponse->drv_status[i].state );
			(*j_env)->CallVoidMethod(j_env, qds, qds_setDriveType, acsResponse->drv_status[i].drive_type );


			jobject qds_drive = (*j_env)->CallObjectMethod(j_env, qds, qds_getDriveId);
			DRIVEID2OBJECT( &(acsResponse->drv_status[i].drive_id), qds_drive, j_env );		



			if( ( acsResponse->drv_status[i].state == STATE_ONLINE ) && 
					(acsResponse->drv_status[i].status == STATUS_DRIVE_IN_USE ) ){
				jobject qds_volume = (*j_env)->CallObjectMethod(j_env, qds, qds_getVolumeId);
				VOLID2OBJECT( &(acsResponse->drv_status[i].vol_id), qds_volume, j_env);
			}

		}
		
	}
	
	(*j_env)->ReleaseByteArrayElements(j_env, j_data, rbuf, 0);
	return ;
}


JNIEXPORT void JNICALL
acsCancelResponse(JNIEnv *j_env, jobject j_obj, jbyteArray j_data, jobject j_res)
{

	ACS_CANCEL_RESPONSE *acsResponse;
	jclass csl;
	

	jbyte *rbuf = (*j_env)->GetByteArrayElements(j_env, j_data, NULL);
	
	acsResponse = (ACS_CANCEL_RESPONSE *)rbuf;
		
	csl = (*j_env)->GetObjectClass(j_env, j_res);
		
	
	jmethodID setStatus      = (*j_env)->GetMethodID(j_env, csl, "setStatus", "(I)V" );
	(*j_env)->CallVoidMethod(j_env, j_res, setStatus, acsResponse->cancel_status );	
	

	jmethodID setReqId      = (*j_env)->GetMethodID(j_env, csl, "setReqId", "(I)V" );
	(*j_env)->CallVoidMethod(j_env, j_res, setReqId, acsResponse->req_id );	


}

JNIEXPORT void JNICALL
acsQueryVolumeResponse(JNIEnv *j_env, jobject j_obj, jbyteArray j_data, jobject j_res)
{
	int i;
	ACS_QUERY_VOL_RESPONSE *acsResponse;
	jclass csl;
	
	
	jbyte *rbuf = (*j_env)->GetByteArrayElements(j_env, j_data, NULL);
	
	acsResponse = (ACS_QUERY_VOL_RESPONSE *)rbuf;
		
	csl = (*j_env)->GetObjectClass(j_env, j_res);
		
	/* get method pointers */
	
	jmethodID setStatus      = (*j_env)->GetMethodID(j_env, csl, "setStatus", "(I)V" );
	(*j_env)->CallVoidMethod(j_env, j_res, setStatus, acsResponse->query_vol_status );


	if( acsResponse->query_vol_status == STATUS_SUCCESS ) {


		jmethodID setCount       = (*j_env)->GetMethodID(j_env, csl, "setCount", "(I)V" );
		jmethodID getVolumeStatus = (*j_env)->GetMethodID(j_env, csl, "getVolumeStatus", "(I)LQU_VOL_STATUS;" );

		(*j_env)->CallVoidMethod(j_env, j_res, setCount, acsResponse->count );

		for ( i = 0; i < acsResponse->count; i++) {
		
			/* get QU_VOL_STATUS */
			jobject qvs = (*j_env)->CallObjectMethod(j_env, j_res, getVolumeStatus, i);
			jclass e_csl = (*j_env)->GetObjectClass(j_env, qvs);

			/* get method pointers */
			jmethodID qvs_getDriveId = (*j_env)->GetMethodID(j_env, e_csl, "getDriveId", "()LDriveId;" );
			jmethodID qvs_getVolumeId = (*j_env)->GetMethodID(j_env, e_csl, "getVolumeId", "()LVolumeId;" );
			jmethodID qvs_getCellId = (*j_env)->GetMethodID(j_env, e_csl, "getCellId", "()LCellId;" );
			jmethodID qvs_setMediaType = (*j_env)->GetMethodID(j_env, e_csl, "setMediaType", "(C)V" );
			jmethodID qvs_setLocation = (*j_env)->GetMethodID(j_env, e_csl, "setLocation", "(I)V" );
			jmethodID qvs_setStatus = (*j_env)->GetMethodID(j_env, e_csl, "setStatus", "(I)V" );


			/* fill QU_DRV_STATUS */
			(*j_env)->CallVoidMethod(j_env, qvs, qvs_setStatus, acsResponse->vol_status[i].status );
			(*j_env)->CallVoidMethod(j_env, qvs, qvs_setLocation, acsResponse->vol_status[i].location_type );
			(*j_env)->CallVoidMethod(j_env, qvs, qvs_setMediaType, acsResponse->vol_status[i].media_type );

			jobject qvs_volume = (*j_env)->CallObjectMethod(j_env, qvs, qvs_getVolumeId);
			VOLID2OBJECT( &(acsResponse->vol_status[i].vol_id), qvs_volume, j_env);
			


			/* FIXME: add error condition test */
			if( acsResponse->vol_status[i].location_type == LOCATION_DRIVE ) {
				jobject qvs_drive = (*j_env)->CallObjectMethod(j_env, qvs, qvs_getDriveId);
				DRIVEID2OBJECT( &(acsResponse->vol_status[i].location.drive_id), qvs_drive, j_env );		
			}else{			
				jobject qvs_cell = (*j_env)->CallObjectMethod(j_env, qvs, qvs_getCellId);
				CELLID2OBJECT( &(acsResponse->vol_status[i].location.cell_id), qvs_cell, j_env );
			}

		}
		
	}

	(*j_env)->ReleaseByteArrayElements(j_env, j_data, rbuf, 0);
	return ;
}



JNIEXPORT int JNICALL
acsQueryServer( JNIEnv *j_env, jobject j_obj, jint j_seqNum )
{
	return acs_query_server( j_seqNum );
}


JNIEXPORT int JNICALL
acsCancel( JNIEnv *j_env, jobject j_obj, jint j_seqNum , jint j_reqId)
{
	return acs_cancel( j_seqNum , j_reqId);
}



JNIEXPORT jstring JNICALL acsStatus (JNIEnv *j_env, jclass j_obj, jint status)
{

	char *msg;
	
	msg = acs_status( status );

	jstring j_msg = (*j_env)->NewStringUTF(j_env, msg);
	return j_msg;

}


JNIEXPORT jstring JNICALL acsState (JNIEnv *j_env, jclass j_obj, jint state)
{

	char *msg;
	
	msg = acs_state( state );

	jstring j_msg = (*j_env)->NewStringUTF(j_env, msg);
	return j_msg;

}
