/*
 * $Id: StorageLibraryHandler.java,v 1.4 2003/05/21 10:30:55 cvs Exp $
 */


class StorageLibraryHandler {
	

   static {
          System.loadLibrary("acs4java");
   }




	native	int acsMount      (int seqNum, int lockId, VolumeId volumeId, DriveId driveId, boolean readonly, boolean bypass );
	native	int acsDismount   (int seqNum, int lockId, VolumeId volumeId, DriveId driveId, boolean force);
	native	int acsQueryDrive (int seqNum, DriveId[] driveId, int count);
	native	int acsQueryVolume(int seqNum, VolumeId[] volumeId, int count);
	native	int acsCancel     (int seqNum, int requestId);
	native  int acsQueryServer(int seqNum);


	native	int acsResponse(int timeout, AcsResponse response);	
	
	// convertor methods. COnvert respose to particular response type	
	static native	void acsMountResponse      (byte[] data, AcsMountResponse response);
	static native	void acsQueryDriveResponse (byte[] data, AcsQueryDriveResponse response);
	static native	void acsQueryVolumeResponse(byte[] data, AcsQueryVolumeResponse response);
	static native	void acsDismountResponse   (byte[] data, AcsDismountResponse response);
	static native	void acsCancelResponse     (byte[] data, AcsCancelResponse response);
//	native	int acsQueryServerResponse(int timeout, int seqNum, int requestId, int requestType, AcsQueryServerResponse response);



	// utility functions
	static native String acsStatus( int status );
	static native String acsState( int state );


	public static void main( String[] args ) {
		StorageLibraryHandler s = new StorageLibraryHandler();
		/*
		s.queryDriveTest();
		s.queryVolumeTest();

		System.out.println("\n\nMounting");
		s.mountTest();
		s.queryDriveTest();
		s.queryVolumeTest();
		
		
		System.out.println("\n\nDismounting");		
		 s.dismountTest(); 
		s.queryDriveTest();
		s.queryVolumeTest();
		*/
		
		s.queryVolumeAllTest();
		
	}


	void dismountTest() {
	
		LsmId lsm = new LsmId(0, 1);
		PanelId panel = new PanelId( lsm, 10 );
		DriveId drive = new DriveId (panel, 3);
		VolumeId volume = new VolumeId("S00001");
						
		acsDismount(501, 0, volume,  drive,  true );
		

		AcsResponse rawResponse = new AcsResponse();
		AcsDismountResponse response = new AcsDismountResponse();		


		do {
			acsResponse(-1, rawResponse) ;

			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {				
				acsDismountResponse( rawResponse.getData(), response);
				System.out.println("Volume " + response.getVolumeId()  + 
				" dismounted from drive " + response.getDriveId() );					
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );		
		

	}



	void mountTest() {
	
		LsmId lsm = new LsmId(0, 1);
		PanelId panel = new PanelId( lsm, 10 );
		DriveId drive = new DriveId (panel, 3);
		VolumeId volume = new VolumeId("S00001");
		
		acsMount(502, 0, volume,  drive,  false, true ) ;
		

		AcsResponse rawResponse = new AcsResponse();
		AcsMountResponse response = new AcsMountResponse();		


		do {
			acsResponse(-1, rawResponse) ;

			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				acsMountResponse( rawResponse.getData(), response);
				System.out.println("Volume " + response.getVolumeId()  + 
				" mounted into drive " + response.getDriveId() );				
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );		
		

	}


	void queryVolumeTest() {

		VolumeId[] volumes = new VolumeId[1];	
		VolumeId volume = new VolumeId("S00001");
		
		volumes[0] = volume;
				
		
		System.out.println("Volume: " + volume.toString() );
		acsQueryVolume( 503, volumes, 1) ;

		AcsResponse rawResponse = new AcsResponse();
		AcsQueryVolumeResponse response = new AcsQueryVolumeResponse();		


		do {
			acsResponse(-1, rawResponse);
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				acsQueryVolumeResponse( rawResponse.getData(), response);
				System.out.print("Volume "+  response.getVolumeStatus(0).getVolumeId()+" in ");
				if(response.getVolumeStatus(0).getLocation() == AcslsHandler.LOCATION_DRIVE) {
					System.out.println("drive " + response.getVolumeStatus(0).getDriveId() );
				}else{
					System.out.println("cell " + response.getVolumeStatus(0).getCellId() );
				}
				
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );

	}



	void queryVolumeAllTest() {

		acsQueryVolume( 506, null, 0) ;

		AcsResponse rawResponse = new AcsResponse();
		AcsQueryVolumeResponse response = new AcsQueryVolumeResponse();		
		long count = 0;

		do {
			acsResponse(-1, rawResponse);
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				acsQueryVolumeResponse( rawResponse.getData(), response);
				
				for( int i = 0; i< response.getCount(); i++ ) {
				
					System.out.print("Volume "+  response.getVolumeStatus(i).getVolumeId()+" in ");
					if(response.getVolumeStatus(i).getLocation() == AcslsHandler.LOCATION_DRIVE) {
						System.out.println("drive " + response.getVolumeStatus(i).getDriveId() );
					}else{
						System.out.println("cell " + response.getVolumeStatus(i).getCellId() );
					}
				
				}
				
				count += response.getCount();
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );

		
		System.out.println("\nIn total  "+ count + " volumes");
	}



	void queryDriveTest() {
	
		LsmId lsm = new LsmId(0, 1);
		PanelId panel = new PanelId( lsm, 10 );
		DriveId drive = new DriveId (panel, 3);
		
		DriveId[] drives = new DriveId[1];
		drives[0] = drive;
		
		
		AcsResponse rawResponse = new AcsResponse();
		AcsQueryDriveResponse response = new AcsQueryDriveResponse();		

		System.out.println("Drive: " + drive.toString() );
		acsQueryDrive(504, drives, 1);

		do {
			acsResponse(-1, rawResponse);
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				acsQueryDriveResponse( rawResponse.getData(), response);
				
				if( response.getDriveStatus(0).getState() == AcslsHandler.STATE_ONLINE ) {
				    System.out.println("Drive status: " + response.getDriveStatus(0).getStatus() );
					System.out.println("Drive : " + response.getDriveStatus(0).getDriveId() );
					if(response.getDriveStatus(0).getStatus() == AcslsHandler.STATUS_DRIVE_IN_USE ) {
						System.out.println("Drive used by volume: " + response.getDriveStatus(0).getVolumeId().getVolumeId() );
					}
				}else {
					System.out.println("Drive state: " + response.getDriveStatus(0).getState() );
				}
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
			
	}
		

	void queryDriveAllTest() {
	
		
		AcsResponse rawResponse = new AcsResponse();
		AcsQueryDriveResponse response = new AcsQueryDriveResponse();		

		acsQueryDrive(505, null, 0);

		do {
			acsResponse(-1, rawResponse);
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				acsQueryDriveResponse( rawResponse.getData(), response);
				
				
				for( int i = 0; i< response.getCount(); i++ ) {
				
					if( response.getDriveStatus(i).getState() == AcslsHandler.STATE_ONLINE ) {
				    	System.out.println("Drive status: " + response.getDriveStatus(i).getStatus() );
						System.out.println("Drive : " + response.getDriveStatus(i).getDriveId() );
						if(response.getDriveStatus(i).getStatus() == AcslsHandler.STATUS_DRIVE_IN_USE ) {
							System.out.println("Drive used by volume: " + response.getDriveStatus(i).getVolumeId().getVolumeId() );
						}
					}else {
						System.out.println("Drive state: " + response.getDriveStatus(i).getState() );
					}
				
				}
				
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
			
	}


};
