/* 
 * $Id: ResponseQueue.java,v 1.2 2003/05/19 13:17:08 cvs Exp $
 */



import java.util.*;

class ResponseQueue {

	private Map _resposeQueue = new HashMap();
	
	
	public synchronized void put(AcsResponse response) {
	
		Object key = (Object) new Integer(response.getSeqNum());
	
		if( _resposeQueue.containsKey(key) ) {
			List list = (List )_resposeQueue.get( key );
			list.add(response);
		}else{
			List list = new ArrayList();
			list.add(response);
			_resposeQueue.put( key , list );
		}

		notifyAll();
	}
	
	
	public synchronized AcsResponse get(int seqNum) {
	
		Object key = (Object) new Integer(seqNum);
		AcsResponse response = null;	
		
		try {		
			do {
			
				while( !_resposeQueue.containsKey(key) ) {
					wait();
				}
								
				
				List list = (List)_resposeQueue.get( key );
				/* our message queue already created, but do we have a message ? 
				
				while( list.size() == 0 ) {
					wait();
				}
				*/
				
				response = (AcsResponse )list.remove( 0 );
				
				/* remove entry if there is no more messages in it */
				if( list.isEmpty() ) {
					_resposeQueue.remove(key);	
				}


			} while( response == null );
		
		} catch  (Exception e) { System.out.println(e);}		

		return  response;
	}
	
	
}
