/*
 * $Id:$
 */

import  dmg.cells.nucleus.* ;
import  dmg.util.* ;

import  java.io.* ;
import  java.util.*;


public class HsmGate extends CellAdapter implements HsmCallback{

	// cell specific 
	private String _cellName      = null;
	private CellNucleus _nucleus  = null ;
	private Args   _args          = null;	



	// HsmGate staff
	private Map _queryList     = new HashMap();
	private StorageLibraryHandler _sHandler = new StorageLibraryHandler();
	private int _seqNumber = 0;
	ResponseQueue _responseQueue =  new ResponseQueue();
	

	
	public HsmGate( String cellName , String args ) throws Exception {    
	
	
		super( cellName , args , false ) ;

		_cellName = cellName ;
		_args     = getArgs() ;
		_nucleus  = getNucleus() ;

		_nucleus.newThread( 
			new Runnable(){
				public void run(){
					while( !Thread.currentThread().isInterrupted()) {
						AcsResponse rawResponse = new AcsResponse();
						int rc = _sHandler.acsResponse(-1, rawResponse) ;
						if(	rc == AcslsHandler.STATUS_SUCCESS ) {
							_responseQueue.put(  rawResponse );
						}
					}
				}
			}
		   , "ACSLS Listener" ).start() ;
		   		   
		useInterpreter( true ) ;

		getNucleus().export();
		start() ;
	}	




	public void getInfo( PrintWriter pw ){
		pw.println("HsmGate $Id:$");
		pw.println( queryDriveAll() );
	}



	public String hh_mount = "<drive> <volume>";
	public String ac_mount_$_2(Args args) {
	
		int reqId;
		DriveId drive = new DriveId( args.argv(0) );
		VolumeId volume = new VolumeId( args.argv(1) );
		
		MountCommand command = new MountCommand( drive, volume, false ); 
		
		try {
			reqId = this.mount( command ) ;
		} catch ( HsmException he ) {
			return "Failed: " + he.toString();
		}

		Object key = (Object) new Integer( reqId );

		Object value = (Object) new HsmRequest(reqId, command);
		synchronized( _queryList ) {
		
			_queryList.put( key , value );
		
		}
		
		
		return "Ok, Request Id " + reqId;
	}

	public String hh_dismount = "<drive> <volume>";
	public String ac_dismount_$_2(Args args) {
	
		int reqId;
		DriveId drive = new DriveId( args.argv(0) );
		VolumeId volume = new VolumeId( args.argv(1) );
		DismountCommand command = new DismountCommand( drive , volume , true ); 
		
		try {
			reqId = this.dismount( command );
		} catch ( HsmException he ) {
			return "Failed: " + he.toString();
		}

		Object key = (Object) new Integer( reqId );
		Object value = (Object) new HsmRequest(reqId, command);
		synchronized( _queryList ) {
		
			_queryList.put( key , value );
		
		}
		
		
		return "Ok, Request Id " + reqId;
	}
	
	public String ac_ls_$_0(Args args) {
		StringBuffer sb = new StringBuffer();
		
		synchronized( _queryList ) {
			
			if( !_queryList.isEmpty() ) {
				Set set = _queryList.keySet();
				Iterator it = set.iterator();

				while ( it.hasNext() ) {
					Object key = it.next() ;
					
					sb.append( _queryList.get( key ) ).append("\n");
				}

			}else{
				sb.append("No active requests\n");
			}
		}
		
		return sb.toString();
		
	}




	public String ac_ls_drive_$_1(Args args) {
		
		return this.lsDrive( new DriveId( args.argv(0) ) );
		
	}


	public String ac_ls_volume_$_1(Args args) {
		
		return this.lsVolume( new VolumeId( args.argv(0) ) );
		
	}



	public void hsmCallback( int id ) {
	
	Object key = (Object) new Integer( id );
	
		synchronized( _queryList ) {
			( (HsmRequest)_queryList.get( key ) ).done();
		}
	}

	public int mount(MountCommand command) throws HsmException  {
	
		int seqNumber = nextSeqNumber();
		int lockId = 0;
		
		int rc = _sHandler.acsMount(seqNumber, lockId, command.getVolume() , command.getDrive(), command.readOnly() , true ) ;
	
		
		CallbackNotifier cB = new CallbackNotifier(seqNumber, this);
		new Thread(cB).start();
		
		return seqNumber;
		
	}
	
	public int dismount( DismountCommand command) throws HsmException {

		int seqNumber = nextSeqNumber();
		int lockId = 0;		
		
		int rc = _sHandler.acsDismount(seqNumber, lockId, command.getVolume() , command.getDrive(), command.force()) ;

		CallbackNotifier cB = new CallbackNotifier(seqNumber, this);
		new Thread(cB).start();
		
		return seqNumber;

	}



	public String lsDrive( DriveId drive ) {
		
		int seqNumber = nextSeqNumber();
		DriveId[] drives = new DriveId[1];
		drives[0] = drive;
		
		StringBuffer os = new StringBuffer();
		
		int rc = _sHandler.acsQueryDrive(seqNumber, drives, 1);
		
		AcsResponse rawResponse = null;
		AcsQueryDriveResponse response = new AcsQueryDriveResponse();
		
		do {
			rawResponse = _responseQueue.get( seqNumber );
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				_sHandler.acsQueryDriveResponse( rawResponse.getData(), response);
				
				
					if( response.getDriveStatus(0).getState() == AcslsHandler.STATE_ONLINE ) {
				    	os.append("Drive ").append( response.getDriveStatus(0).getDriveId() );
							
							
						if(response.getDriveStatus(0).getStatus() == AcslsHandler.STATUS_DRIVE_IN_USE ) {
							os.append(" used by volume: ").
								append( response.getDriveStatus(0).getVolumeId().getVolumeId() ).
								append("\n");
						}else {
							os.append(" free\n");
						}
					}else {
						os.append("Drive state: " + response.getDriveStatus(0).getState() ).
							append("\n");
					}				
				
				
			}
			
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
		
		return os.toString();
		
		
	}



	public String lsVolume( VolumeId volume ) {
		
		int seqNumber = nextSeqNumber();
		VolumeId[] volumes = new VolumeId[1];
		volumes[0] = volume;
		
		StringBuffer os = new StringBuffer();
		
		int rc = _sHandler.acsQueryVolume(seqNumber, volumes, 1);
		
		AcsResponse rawResponse = null;
		AcsQueryVolumeResponse response = new AcsQueryVolumeResponse();
		
		do {
			rawResponse = _responseQueue.get( seqNumber );
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				_sHandler.acsQueryVolumeResponse( rawResponse.getData(), response);
				
				
				os.append("Volume ").append(response.getVolumeStatus(0).getVolumeId()).
					append(" in ");
					
				if(response.getVolumeStatus(0).getLocation() == AcslsHandler.LOCATION_DRIVE) {
					os.append("drive ").append( response.getVolumeStatus(0).getDriveId()  );
				}else{
					os.append("cell ").append( response.getVolumeStatus(0).getCellId() );
				}				
				
			}
			
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
		
		return os.toString();
		
		
	}


	public String queryDriveAll() {
	
		int seqNumber = nextSeqNumber();
	
		StringBuffer os = new StringBuffer();	
		
		AcsResponse rawResponse = null;
		AcsQueryDriveResponse response = new AcsQueryDriveResponse();		

		_sHandler.acsQueryDrive(seqNumber, null, 0);

		do {
			rawResponse = _responseQueue.get( seqNumber );
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				_sHandler.acsQueryDriveResponse( rawResponse.getData(), response);
				
				
				for( int i = 0; i< response.getCount(); i++ ) {
				
					if( response.getDriveStatus(i).getState() == AcslsHandler.STATE_ONLINE ) {
				    	os.append("Drive ").append( response.getDriveStatus(i).getDriveId() );
							
							
						if(response.getDriveStatus(i).getStatus() == AcslsHandler.STATUS_DRIVE_IN_USE ) {
							os.append(" used by volume: ").
								append( response.getDriveStatus(i).getVolumeId().getVolumeId() ).
								append("\n");
						}else {
							os.append(" free\n");
						}
					}else {
						os.append("Drive state: " + response.getDriveStatus(i).getState() ).
							append("\n");
					}
				
				}
				
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
		
		
		return os.toString();		
				
	}




	synchronized int nextSeqNumber() {
		return ++ _seqNumber;
	}



	class CallbackNotifier implements Runnable {
	
	
		private int seqNumber;
		private HsmCallback cB;
		
		CallbackNotifier( int waitFor, HsmCallback cb ) {
			seqNumber = waitFor;
			cB = cb;
		}
		
	
		public void run() {
		
		
			AcsResponse rawResponse = new AcsResponse();
			
			do {
				rawResponse = _responseQueue.get( seqNumber );
			}while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
			

			cB.hsmCallback( seqNumber );
			
		
		}
	
	} // class CallbackNotifier

}
