/*
 * $Id: DriveId.java,v 1.2 2003/05/21 08:42:50 cvs Exp $
 */

class DriveId {

	private PanelId  _panel_id;
    private int    _drive; /* acsapi DRIVE */
	
	DriveId() {
		_panel_id = new PanelId();
	}
	
	DriveId(PanelId panel_id, int drive){
		_panel_id = panel_id;
		_drive = drive;	
	}
	
	
	DriveId( String drive ) {
	
		int acs_id;
		int lsm_id;
		int panel_id;
		int drive_id;
		int inx;
		int inx2;
		
		inx = drive.indexOf(':');
		
		acs_id = Integer.parseInt( drive.substring(0, inx) );
		
		inx2 = drive.indexOf(':', ++inx);
		lsm_id = Integer.parseInt( drive.substring(inx, inx2) );
		
		inx =  inx2;
		inx2 = drive.indexOf(':', ++inx);
		panel_id = Integer.parseInt( drive.substring(inx, inx2) );
		
		
		drive_id = Integer.parseInt( drive.substring(++inx2) );
				
		
		LsmId lsm = new LsmId(acs_id, lsm_id);
		_panel_id = new PanelId( lsm, panel_id );
		_drive = drive_id;	
	}
	
	
	int getDrive() {
		return _drive;
	}
	
	int getAcs() {
		return _panel_id.getLsmId().getAcs();
	}
	
	int getLsm() {	
		return _panel_id.getLsmId().getLsm();
	}


	int getPanel(){
		return _panel_id.getPanel();
	}




	void setDrive(int drive) {
		_drive = drive;
	}
	
	void setAcs( int acs) {
		_panel_id.getLsmId().setAcs(acs);
	}
	
	void setLsm(int lsm) {
		_panel_id.getLsmId().setLsm(lsm);
	}


	void setPanel(int panel){
		_panel_id.setPanel(panel);
	}
	
	
	public String toString() {
		return getAcs() + ":" + getLsm() + ":"+getPanel()+":"+getDrive();
	}
	
	
	
	
	public static void main( String[] args ) {
		
		System.out.println( new DriveId("10:22:34:45") );	
	
	}
			
	
}
