/*
 * $Id: AcsDispatcher.java,v 1.1 2003/05/19 12:54:45 cvs Exp $
 */



class AcsDispatcher {


	private StorageLibraryHandler _sHandler = new StorageLibraryHandler();
	private int _seqNumber = 0;
	ResponseQueue _responseQueue =  new ResponseQueue();


	public static void main( String[] args ) {
		AcsDispatcher d = new AcsDispatcher();
		d.start();
	}
		

	void start() {
		ResponseThread rt = new ResponseThread();

		new Thread(rt).start();
		queryVolumeAllTest();
		queryDriveAllTest();		
	}




	class ResponseThread implements Runnable {
	
		public void run() {
		
			while( !Thread.currentThread().isInterrupted()) {
				AcsResponse rawResponse = new AcsResponse();
				int rc = _sHandler.acsResponse(-1, rawResponse) ;
				if(	rc == AcslsHandler.STATUS_SUCCESS ) {
					_responseQueue.put(  rawResponse );
				}
			}
		}
	
	
	}


	void queryDriveAllTest() {
	
		
		AcsResponse rawResponse = null;
		AcsQueryDriveResponse response = new AcsQueryDriveResponse();		

		_sHandler.acsQueryDrive(505, null, 0);

		do {
			rawResponse = _responseQueue.get( 505 );
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				_sHandler.acsQueryDriveResponse( rawResponse.getData(), response);
				
				
				for( int i = 0; i< response.getCount(); i++ ) {
				
					if( response.getDriveStatus(i).getState() == AcslsHandler.STATE_ONLINE ) {
				    	System.out.println("Drive status: " + response.getDriveStatus(i).getStatus() );
						System.out.println("Drive : " + response.getDriveStatus(i).getDriveId() );
						if(response.getDriveStatus(i).getStatus() == AcslsHandler.STATUS_DRIVE_IN_USE ) {
							System.out.println("Drive used by volume: " + response.getDriveStatus(i).getVolumeId().getVolumeId() );
						}
					}else {
						System.out.println("Drive state: " + response.getDriveStatus(i).getState() );
					}
				
				}
				
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );
			
	}



	void queryVolumeAllTest() {


		AcsResponse rawResponse = null;
		AcsQueryVolumeResponse response = new AcsQueryVolumeResponse();		
		
		_sHandler.acsQueryVolume( 507, null, 0) ;


		long count = 0;

		do {
			rawResponse = _responseQueue.get( 507 );
			if( rawResponse.getResponseType() != AcslsHandler.RT_ACKNOWLEDGE ) {
				_sHandler.acsQueryVolumeResponse( rawResponse.getData(), response);
				
				for( int i = 0; i< response.getCount(); i++ ) {
				
					System.out.print("Volume "+  response.getVolumeStatus(i).getVolumeId()+" in ");
					if(response.getVolumeStatus(i).getLocation() == AcslsHandler.LOCATION_DRIVE) {
						System.out.println("drive " + response.getVolumeStatus(i).getDriveId() );
					}else{
						System.out.println("cell " + response.getVolumeStatus(i).getCellId() );
					}
				
				}
				
				count += response.getCount();
			}
		} while( rawResponse.getResponseType() != AcslsHandler.RT_FINAL );

		
		System.out.println("\nIn total  "+ count + " volumes");
	}




}
