
*                     Short LVMINI test program

      CALL ROSENB     ! Rosenbrock function
      DO LTRY=1,3
       CALL STLINE     ! Straight line fit
      END DO  
      END


      SUBROUTINE ROSENB   ! Rosenbrock minimization
      PARAMETER           (NAUX=1000)
      DOUBLE PRECISION AUX(NAUX)
      DOUBLE PRECISION PAR(2),FSUM
      DOUBLE PRECISION FOPT,FEDM,DUMMY
      EXTERNAL ROSEN
*     ...
      NPAR=2
      PAR(1)=-1.2D0                 ! minimize by LVMINI
      PAR(2)=+1.0D0
      CALL LVMEPS(1.0E-9,0.0,0.0)
      CALL LVMINI(-NPAR,-NPAR, 1000,AUX)
 10   CALL ROSEN(NPAR,AUX,FSUM,PAR,IFLAG)
      CALL LVMFUN(PAR,FSUM,IRET,AUX)
      IF(IRET.LT.0) GOTO 10

c      PAR(1)=-1.2D0                 ! minimize by MINUIT
c      PAR(2)=+1.0D0
c      CALL MNINIT(5,6,7)
c      CALL MNSETI('Rosenbrok by Minuit') 
c      CALL MNPARM(1,'   ',PAR(1),0.1D0,0.0D0,0.0D0,IERF)
c      CALL MNPARM(2,'   ',PAR(2),0.1D0,0.0D0,0.0D0,IERF)
c      CALL MNCOMD(ROSEN,'SET ERRORDEF 0.5 ',ICONDN,0)
c      CALL MNCOMD(ROSEN,'MINIMIZE  1000 0.00001 ',ICONDN,0)

c      PAR(1)=-1.2D0                 ! minimize by MINUIT
c      PAR(2)=+1.0D0                 ! ...  with gradient
c      CALL MNINIT(5,6,7)
c      CALL MNSETI('Rosenbrok by Minuit') 
c      CALL MNPARM(1,'   ',PAR(1),0.1D0,0.0D0,0.0D0,IERF)
c      CALL MNPARM(2,'   ',PAR(2),0.1D0,0.0D0,0.0D0,IERF)
c      CALL MNCOMD(ROSEN,'SET GRADIENT force ',ICONDN,0)
c      CALL MNCOMD(ROSEN,'SET ERRORDEF 0.5 ',ICONDN,0)
c      CALL MNCOMD(ROSEN,'MINIMIZE  1000 0.00001 ',ICONDN,0)
      END

      SUBROUTINE ROSEN(NPAR,GRAD,FSUM,PAR,IFLAG)
      DOUBLE PRECISION GRAD(2),FSUM,PAR(2)
*     ...
      FSUM=(1.0D0-PAR(1))**2+100.0D0*(PAR(2)-PAR(1)**2)**2
*     gradient
      GRAD(1)=-2.0D0*(1.0-PAR(1))-400.0D0*(PAR(2)-PAR(1)**2)*PAR(1)
      GRAD(2)=200.0D0*(PAR(2)-PAR(1)**2)
      END


*     straight line least squares fit ----------------------------------

      SUBROUTINE STLINE ! straight line fit with FUNSTL
      COMMON/CXYDY/X(100),Y(100),DY(100)
      DOUBLE PRECISION PAR(2),GRAD(2),FSUM
      PARAMETER (NAUX=1000)
      DOUBLE PRECISION AUX(NAUX)
      EXTERNAL FUNSTL
*

      PAR1=1.5         ! generate MC
      PAR2=0.35
      DO I=1,100
       X(I)=I
       DY(I)=0.1
       Y(I)=PAR1+PAR2*X(I)+DY(I)*UGAUSS()
      END DO

      NPAR=2           ! fit LVMINI, using MINUIT-like function
      PAR(1)=0.0D0
      PAR(2)=0.0D0
      CALL LVMEPS(0.0,0.0,0.0)
      CALL LVMIDI(-NPAR,PAR, FUNSTL,AUX)

      NPAR=2           ! fit LVMINI, with Hesse diagonal
      PAR(1)=0.0D0
      PAR(2)=0.0D0
      CALL LVMEPS(0.0,0.0,0.0)
      CALL LVMINI(-NPAR,-NPAR, 0,AUX)
 10   FSUM=0.0D0
      DO I=1,100
       FIT=PAR(1)+PAR(2)*X(I)
       WT=1.0/DY(I)**2
       AUX(1)=AUX(1)+WT*1.0D0*(FIT-Y(I))
       AUX(2)=AUX(2)+WT*X(I)*(FIT-Y(I))
       AUX(3)=AUX(3)+WT*1.0D0**2
       AUX(4)=AUX(4)+WT*X(I)**2
       FSUM=FSUM+WT*(FIT-Y(I))**2
      END DO
      FSUM=0.5D0*FSUM
      CALL LVMFUN(PAR,FSUM,IRET,AUX)
      IF(IRET.LT.0) GOTO 10

*     ... and MINUIT

c      PAR(1)=0.0D0
c      PAR(2)=0.0D0
c      CALL MNINIT(5,6,7) 
c      CALL MNSETI('Straight line fit by Minuit')
c      CALL MNPARM(1,'   ',PAR(1),0.02D0,0.0D0,0.0D0,IERF)
c      CALL MNPARM(2,'   ',PAR(2),0.00035D0,0.0D0,0.0D0,IERF)
c      CALL MNCOMD(FUNSTL,'SET ERRORDEF 0.5 ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'MINIMIZE ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'HESSE ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'MINOS 1000 1 2  ',ICONDN,0) 

*     ... and MINUIT with gradient

c      PAR(1)=0.0D0
c      PAR(2)=0.0D0
c      CALL MNINIT(5,6,7) 
c      CALL MNSETI('Straight line fit by Minuit')
c      CALL MNPARM(1,'   ',PAR(1),0.02D0,0.0D0,0.0D0,IERF)
c      CALL MNPARM(2,'   ',PAR(2),0.00035D0,0.0D0,0.0D0,IERF)
c      CALL MNCOMD(FUNSTL,'SET GRADIENT ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'SET ERRORDEF 0.5 ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'MINIMIZE ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'HESSE ',ICONDN,0)
c      CALL MNCOMD(FUNSTL,'MINOS 1000 1 2  ',ICONDN,0) 

      END

      SUBROUTINE FUNSTL(NPAR,GRAD,FSUM,PAR,IFLAG)
      DOUBLE PRECISION GRAD(4),PAR(2),FSUM
      COMMON/CXYDY/X(100),Y(100),DY(100)
      DOUBLE PRECISION FIT

*     ...
      FSUM=0.0D0
      DO J=1,2
       GRAD(J)=0.0D0
      END DO
      DO I=1,100
       FIT=PAR(1)+PAR(2)*X(I)
       WT=1.0/DY(I)**2
       GRAD(1)=GRAD(1)+WT*1.0D0*(FIT-Y(I))
       GRAD(2)=GRAD(2)+WT* X(I)*(FIT-Y(I))
       FSUM=FSUM+WT*(FIT-Y(I))**2
      END DO
      FSUM=0.5D0*FSUM
c      WRITE(*,101) FSUM,PAR(1),PAR(2),GRAD(1),GRAD(2)
 101  FORMAT(2X,G12.4,2F14.7,2F10.5)     
      END


      FUNCTION UGAUSS()  ! return Gaussian random number N(0,1)
*     simple Gaussian generator, not for accurate calculations!
      PARAMETER (IA=205,IC=29573,IM=139968)
      DATA LAST/4711/,KN/1/
      SAVE 
*     ... 
      IF(KN.LE.1) THEN
*        two U(-1,+1) random numbers
 10      LAST=MOD(IA*LAST+IC,IM)
         IF(LAST.EQ.0) LAST=MOD(IA*LAST+IC,IM)
         U1=2.0*FLOAT(LAST)/FLOAT(IM)-1.0 ! U(-1,+1)
         LAST=MOD(IA*LAST+IC,IM)
         IF(LAST.EQ.0) LAST=MOD(IA*LAST+IC,IM)
         U2=2.0*FLOAT(LAST)/FLOAT(IM)-1.0 ! U(-1,+1)
         RADSQ=U1*U1+U2*U2
         IF(RADSQ.GT.1.0) GOTO 10 ! point inside circle?
*        transform to gaussians
         AL=SQRT(-2.0*LOG(RADSQ))
         UGAUSS=U1*AL/SQRT(RADSQ)
         KN =2
      ELSE
         UGAUSS=U2*AL/SQRT(RADSQ) 
         KN =1
      END IF
      END






